//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
template <typename T>
class C_TreeNode
{
    private :
//+----------------+
        T           info;
        C_TreeNode  *left,
                    *right;
        int         prof;
//+----------------+
    public  :
//+----------------+
        C_TreeNode(T arg)
            :left(NULL),
            right(NULL),
            info(arg),
            prof(1)
        {}
//+----------------+
        void SetInfo(const T arg) { info = arg; }
//+----------------+
        void SetLeft(C_TreeNode *ptr) { left = ptr; }
//+----------------+
        void SetRight(C_TreeNode *ptr) { right = ptr; }
//+----------------+
        void SetProf(const int arg) { prof = arg; }
//+----------------+
        int GetProf(void) { return prof; }
//+----------------+
        T GetInfo(void) const { return info; }
//+----------------+
        C_TreeNode *GetLeft(void) const { return left; }
//+----------------+
        C_TreeNode *GetRight(void) const { return right; }
//+----------------+
};
//+------------------------------------------------------------------+
#define C_TreeNode C_TreeNode<T>
template <typename T>
class C_Tree
{
//+----------------+
    #define def_InfoToString(A) (A != NULL ? StringFormat("%d ", (*A).GetInfo()) : "")
    enum E_SEQ {eInOrder, ePreOrder, ePostOrder, eDestroy};
//+----------------+
    private :
        C_TreeNode *root;
        string      m_szInfo;
//+----------------+
        int WhatProf(C_TreeNode *ptr)
        {
            C_TreeNode *p1, *p2;

            p1 = (*ptr).GetLeft();
            p2 = (*ptr).GetRight();

            if (p1 && p2)
                return MathMax((*p1).GetProf(), (*p2).GetProf()) + 1;
            return  (p1 && (p2 == NULL) ? (*p1).GetProf() : (*p2).GetProf()) + 1;
        }
//+----------------+
        int BalanceFactor(C_TreeNode *ptr)
        {
            C_TreeNode *p1, *p2;

            p1 = (ptr == NULL ? NULL : (*ptr).GetLeft());
            p2 = (ptr == NULL ? NULL : (*ptr).GetRight());
            if ((p1 == NULL) && (p2 == NULL)) return 0;
            if (p1 && p2) return ((*p1).GetProf() - (*p2).GetProf());
            return ((p1 != NULL) && (p2 == NULL) ? (*p1).GetProf() : -(*p2).GetProf());
        }
//+----------------+
        C_TreeNode *Rotation_R(C_TreeNode *ptr)
        {
            C_TreeNode *p1;
            
            p1 = (*ptr).GetRight();
            (*ptr).SetRight((*p1).GetLeft());
            (*p1).SetLeft(ptr);

            return p1;
        }
//+----------------+
        C_TreeNode *Rotation_L(C_TreeNode *ptr)
        {
            C_TreeNode *p1;
            
            p1 = (*ptr).GetLeft();
            (*ptr).SetLeft((*p1).GetRight());
            (*p1).SetRight(ptr);

            return p1;
        }
//+----------------+
        C_TreeNode *Rotation_2R(C_TreeNode *ptr)
        {
            C_TreeNode *p1, *p2;

            p1 = (*ptr).GetRight();
            p2 = (*p1).GetLeft();
            (*ptr).SetRight((*p2).GetLeft());
            (*p1).SetLeft((*p2).GetRight());
            (*p2).SetLeft(ptr);
            (*p2).SetRight(p1);

            return p2;
        }
//+----------------+
        C_TreeNode *Rotation_2L(C_TreeNode *ptr)
        {
            C_TreeNode *p1, *p2;

            p1 = (*ptr).GetLeft();
            p2 = (*p1).GetRight();
            (*ptr).SetLeft((*p2).GetRight());
            (*p1).SetRight((*p2).GetLeft());
            (*p2).SetRight(ptr);
            (*p2).SetLeft(p1);

            return p2;
        }
//+----------------+
        C_TreeNode *Insert(C_TreeNode *ptr, T info)
        {
            int i;

            if (ptr == NULL)
                return new C_TreeNode(info);

            if (info < (*ptr).GetInfo()) (*ptr).SetLeft(Insert((*ptr).GetLeft(), info));
            else (*ptr).SetRight(Insert((*ptr).GetRight(), info));
            (*ptr).SetProf(WhatProf(ptr));
            i = BalanceFactor(ptr);
            if (i > 1) ptr = (BalanceFactor((*ptr).GetLeft()) >= 0 ? Rotation_L(ptr) : Rotation_2L(ptr)); 
            else if (i < -1) ptr = (BalanceFactor((*ptr).GetRight()) <= 0 ? Rotation_R(ptr) : Rotation_2R(ptr)); 

            return ptr;
        }
//+----------------+
        C_TreeNode *Erase(C_TreeNode *ptr, T info)
        {
            C_TreeNode *tmp;
            int         i;

            if (((*ptr).GetLeft() == NULL) && ((*ptr).GetRight() == NULL))
            {
                delete ptr;
                return NULL;
            }
            if ((*ptr).GetInfo() < info) (*ptr).SetRight(Erase((*ptr).GetRight(), info)); else
            if ((*ptr).GetInfo() > info) (*ptr).SetLeft(Erase((*ptr).GetLeft(), info)); else
            {
                if ((*ptr).GetLeft() != NULL)
                {
                    tmp = (*ptr).GetLeft();
                    while ((*tmp).GetRight() != NULL) tmp = (*tmp).GetRight();
                    (*ptr).SetInfo((*tmp).GetInfo());
                    (*ptr).SetLeft(Erase((*ptr).GetLeft(), (*tmp).GetInfo()));
                }else
                {
                    tmp = (*ptr).GetRight();
                    while ((*tmp).GetLeft() != NULL) tmp = (*tmp).GetLeft();
                    (*ptr).SetInfo((*tmp).GetInfo());
                    (*ptr).SetRight(Erase((*ptr).GetRight(), (*tmp).GetInfo()));
                }
            }
            i = BalanceFactor(ptr);
            if (i > 1) ptr = (BalanceFactor((*ptr).GetLeft()) >= 0 ? Rotation_L(ptr) : Rotation_2L(ptr)); 
            else if (i < -1) ptr = (BalanceFactor((*ptr).GetRight()) <= 0 ? Rotation_R(ptr) : Rotation_2R(ptr)); 

            return ptr;
        }
//+----------------+
        void Seq(C_TreeNode *ptr, const E_SEQ type)
        {
            if (ptr == NULL) return;

            switch (type)
            {
                case eInOrder   :
                case ePostOrder :
                case eDestroy   :
                    Seq((*ptr).GetLeft(), type);
                    if (type == eInOrder) break;
                    Seq((*ptr).GetRight(), type);
            }
            m_szInfo += def_InfoToString(ptr);
            switch (type)
            {
                case ePreOrder  :
                    Seq((*ptr).GetLeft(), type);
                case eInOrder   :
                    Seq((*ptr).GetRight(), type);
                    break;
                case eDestroy   :
                    delete ptr;
            }
        }
//+----------------+
    public  :
//+----------------+
        C_Tree()
            :root(NULL)
        {}
//+----------------+
        ~C_Tree()
        {
            Seq(root, eDestroy);
        }
//+----------------+
        void Store(T info)
        {
            root = Insert(root, info);
        }
//+----------------+
        string In_Order(void)
        {
            m_szInfo = "In Order: ";
            Seq(root, eInOrder);
            
            return m_szInfo;
        }
//+----------------+
        string Pre_Order(void)
        {
            m_szInfo = "Pre Order: ";
            Seq(root, ePreOrder);

            return m_szInfo;
        }
//+----------------+
        string Post_Order(void)
        {
            m_szInfo = "Post Order: ";
            Seq(root, ePostOrder);

            return m_szInfo;
        }
//+----------------+
        void DeleteNode(const T info)
        {
            root = Erase(root, info);
        }
//+----------------+
    #undef def_InfoToString
//+----------------+
};
#undef C_TreeNode
//+------------------------------------------------------------------+
void OnStart(void)
{
    C_Tree <int> Tree;

    Tree.Store(10);
    Tree.Store(-6);
    Tree.Store(47);
    Tree.Store(35);
    Tree.Store(51);
    Tree.Store(90);
    Tree.Store(85);
    Tree.Store(40);

    Print(Tree.In_Order());
    Print(Tree.Pre_Order());
    Print(Tree.Post_Order());

    Tree.DeleteNode(10);
    Tree.DeleteNode(-6);
    Print("-----------");
    Print(Tree.In_Order());
    Print(Tree.Pre_Order());
    Print(Tree.Post_Order());
}
//+------------------------------------------------------------------+